/*!
 * 后台路由
 * 米拓企业建站系统 Copyright (C) 长沙米拓信息技术有限公司 (https://www.metinfo.cn). All rights reserved.
 */
window.ROUTERS = {
    home: {
        module: 'index',
        path: 'home',
        data: {
            c: 'index',
            a: 'dohome'
        },
        js: 'home'
    },
    manage: {
        js: 'manage',
        css: 'manage'
    },
    online: {
        sub: {
            set: {
                js: 'setonline'
            },
            list: {
                js: 'online'
            }
        }
    },
    seo: {
        sub: {
            seo: {
                js: 'seo'
            },
            link: {
                js: 'link'
            },
            anchor: {
                js: 'anchor'
            },
            pseudostatic: {
                js: 'pseudostatic'
            },
            staticpage: {
                js: 'staticpage',
                css: 'html'
            },
            sitemap: {
                js: 'sitemap'
            },
            tags: {
                js: 'tags'
            }
        }
    },
    myapp: {
        css: 'myapp',
        sub: {
            login: {
                css: 'myapp',
                js: 'login'
            },
            myapp: {
                js: 'myapp'
            },
            free: {
                js: 'free'
            },
            business: {
                js: 'business'
            },
            charge: {
                js: 'charge'
            }
        }
    },
    user: {
        sub: {
            list: {
                js: 'list'
            },
            group: {
                js: 'group'
            },
            attr: {
                js: 'attr',
                css: 'attr'
            },
            func: {
                js: 'func'
            },
            login: {
                js: 'login'
            },
            email: {
                js: 'email'
            }
        }
    },
    admin: {
        sub: {
            admin_sys: {
                js: 'admin'
            }
        }
    },
    permission: {
        sub: {
            role_list: {
                js: 'permission'
            },
            member_list: {
                js: 'permission'
            }
        }
    },
    safe: {
        sub: {
            logs: {
                js: 'logs'
            },
            safe: {
                js: 'safe'
            },
            database:{
                js: 'database'
            },
            email: {
                js: 'email'
            }
        }
    },
    databack: {
        sub: {
            backup: {
                js: 'backup'
            },
            recovery: {
                js: 'recovery'
            }
        }
    },
    webset: {
        sub: {
            webset:{
                js: 'webset'
            },
            thirdparty: {
                js: 'third'
            }
        }
    },
    column: {
        js: 'column',
        css: 'column'
    },
    language: {
        sub: {
            site: {
                js: 'site',
                css: 'lang'
            },
            admin: {
                js: 'admin',
                css: 'lang'
            },
            setting: {
                js: 'setting'
            }
        }
    },
    imgmanage: {
        sub: {
            thumbs: {
                js: 'thumbs',
                css: 'thumbs'
            },
            watermark: {
                js: 'watermark'
            }
        }
    },
    update: {
        js: 'update'
    },
    parameter: {
        sub: {
            list: {
                js: 'parameter'
            }
        }
    },
    message: {
        sub: {
            list: {
                js: 'message'
            },
            set: {
                js: '#pub/js/form_sys_set'
            }
        }
    },
    feedback: {
        sub: {
            list: {
                js: 'feedback'
            },
            set: {
                js: '#pub/js/form_sys_set'
            }
        }
    },
    job: {
        sub: {
            position_list: {
                js: 'job'
            },
            list: {
                js: 'job'
            },
            set: {
                js: '#pub/js/form_sys_set'
            }
        }
    },
    system: {
        sub: {
            news: {
                js: 'sys_news'
            },
            authcode: {
                data: {
                    c: 'authcode',
                    a: 'doindex'
                }
            }
        }
    },
    banner: {
        path: 'list',
        js: 'banner',
        data: {
            c: 'banner_admin',
            a: 'domanage'
        }
    },
    recycle: {
        js: 'recycle'
    },
    partner: {
        js: 'partner',
        css: 'partner'
    },
    menu: {
        js: 'menu'
    },
    search: {
        sub: {
            global: {
                js: 'global'
            },
            advanced: {
                js: 'advanced'
            }
        }
    },
    relation: {
        sub: {
            list: {
                js: 'relation'
            }
        }
    },
    myfiles: {
        module: 'files',
        // path: 'files',
        // data: {
        //     c: 'index',
        //     a: 'dohome'
        // },
        js: 'files'
    },
};